% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipboard.R
\name{clipboard}
\alias{clipboard}
\alias{write_clipboard}
\alias{read_clipboard}
\title{Write to and read from the clipboard}
\usage{
write_clipboard(x, ...)

read_clipboard(method = c("default", "data.frame", "tibble"), ...)
}
\arguments{
\item{x}{An object}

\item{...}{Additional arguments sent to methods}

\item{method}{Method switch for loading the clipboard}
}
\value{
\code{write_clipboard()} None, called for side effects
\code{read_clipboard()} Either a vector, \code{data.frame}, or \code{tibble} depending on
the \code{method} chosen
}
\description{
Wrappers for working with the clipboard
}
\details{
As these functions rely on \code{utils::readClipboard()} and
\code{utils::writeClipboard} they are only available for Windows 10.
For copying and pasting floats, there may be some rounding that can occur.
}
\examples{
# Will only run on windows
if (Sys.info()[["sysname"]] == "Windows") {
  foo <- function(x) {
    write_clipboard(x)
    y <- read_clipboard()
    res <- all.equal(x, y)
    if (isTRUE(res)) return("All equal")
    print(x)
    print(y)
  }
  foo(1:4)
  foo(seq(-1, 1, .02))
  foo(Sys.Date() + 1:4)

  # May have some rounding issues
  x <- "0.316362437326461129"
  write_clipboard(x)
  res <- as.character(read_clipboard())
  all.equal(x, res)
  x; res
}
}
