#' Example fishery independent survey data
#'
#' A dataframe of example fishery independent survey data for two areas (AREA1
#' and AREA2) from 2014 - 2019.
#'
#' Indicators calculated using fishery independent data (among other arguments):
#' Heip's Evenness Index, Hill's N1, Hill's N2, Kempton's Q, Margalef's Species
#' Richness, Pielou's Species Evenness, Shannon's Diversity Index, Biomass
#' ratio(s), Abundance/Biomass of Species Groups, Large Species Indicator, Mean
#' Trophic Level of the Community, CV of Biomass, Mean Maximum Lifespan, Mean
#' Maximum Length, and Fishing Pressure.

#' @format This example data is a dataframe with 2003 rows and 5 variables: \describe{
#'   \item{YEAR}{Year the observation was recorded} \item{ID}{Area where the
#'   observation was recorded} \item{SPECIES}{Numeric code indicating the
#'   species sampled} \item{ABUNDANCE}{Abundance of the species sampled,
#'   stratified and corrected for catchability} \item{BIOMASS}{Biomass of the
#'   sampled species, stratified and corrected for catchability} }
#'
#' @source This is made-up example data modified from Fisheries and Oceans
#'   Canada summer research vessel trawl survey for the Scotian Shelf Bioregion.
"X"