% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.marginaleffects}
\alias{summary.marginaleffects}
\title{Summarize a \code{marginaleffects} object}
\usage{
\method{summary}{marginaleffects}(object, conf_level = NULL, ...)
}
\arguments{
\item{object}{An object produced by the \code{marginaleffects} function}

\item{conf_level}{numeric value between 0 and 1. Confidence level to use to build a confidence interval.}

\item{...}{Additional arguments are passed to the \code{predict()} method
supplied by the modeling package.These arguments are particularly useful
for mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?marginaleffects} documentation for a non-exhaustive list of available
arguments.}
}
\value{
Data frame of summary statistics for an object produced by the
\code{marginaleffects} function
}
\description{
Summarize a \code{marginaleffects} object
}
\examples{
mod <- lm(mpg ~ hp * wt + factor(gear), data = mtcars)
mfx <- marginaleffects(mod)

# average marginal effects
summary(mfx)
}
\seealso{
Other summary: 
\code{\link{glance.marginaleffects}()},
\code{\link{reexports}},
\code{\link{summary.comparisons}()},
\code{\link{summary.marginalmeans}()},
\code{\link{summary.predictions}()},
\code{\link{tidy.comparisons}()},
\code{\link{tidy.deltamethod}()},
\code{\link{tidy.marginaleffects}()},
\code{\link{tidy.marginalmeans}()},
\code{\link{tidy.predictions}()}
}
\concept{summary}
