% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltamethod.R
\name{deltamethod}
\alias{deltamethod}
\title{Estimate and Standard Error of a Non-Linear Function of Estimated Model Parameters}
\usage{
deltamethod(
  model,
  hypothesis = NULL,
  FUN = NULL,
  vcov = NULL,
  conf_level = 0.95,
  ...
)
}
\arguments{
\item{model}{Model object}

\item{hypothesis}{specify a hypothesis test or custom contrast using a vector, matrix, string, or string formula.
\itemize{
\item String:
\itemize{
\item "pairwise": pairwise differences between estimates in each row.
\item "reference": differences between the estimates in each row and the estimate in the first row.
}
\item String formula to specify linear or non-linear hypothesis tests. If the \code{term} column uniquely identifies rows, terms can be used in the formula. Otherwise, use \code{b1}, \code{b2}, etc. to identify the position of each parameter. Examples:
\itemize{
\item \code{hp = drat}
\item \code{hp + drat = 12}
\item \code{b1 + b2 + b3 = 0}
}
\item Numeric vector: Weights to compute a linear combination of (custom contrast between) estimates. Length equal to the number of rows generated by the same function call, but without the \code{hypothesis} argument.
\item Numeric matrix: Each column is a vector of weights, as describe above, used to compute a distinct linear combination of (contrast between) estimates.
\item See the Examples section below and the vignette: https://vincentarelbundock.github.io/marginaleffects/articles/hypothesis.html
}}

\item{FUN}{a function which accepts a model object and returns a numeric
vector or a data.frame with two columns called \code{term} and \code{estimate}.}

\item{vcov}{Type of uncertainty estimates to report (e.g., for robust standard errors). Acceptable values:
\itemize{
\item FALSE: Do not compute standard errors. This can speed up computation considerably.
\item TRUE: Unit-level standard errors using the default \code{vcov(model)} variance-covariance matrix.
\item String which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}
\item Heteroskedasticity and autocorrelation consistent: \code{"HAC"}
\item Mixed-Models degrees of freedom: "satterthwaite", "kenward-roger"
\item Other: \code{"NeweyWest"}, \code{"KernHAC"}, \code{"OPG"}. See the \code{sandwich} package documentation.
}
\item One-sided formula which indicates the name of cluster variables (e.g., \code{~unit_id}). This formula is passed to the \code{cluster} argument of the \code{sandwich::vcovCL} function.
\item Square covariance matrix
\item Function which returns a covariance matrix (e.g., \code{stats::vcov(model)})
}}

\item{conf_level}{numeric value between 0 and 1. Confidence level to use to build a confidence interval.}

\item{...}{Additional arguments are passed to the \code{predict()} method
supplied by the modeling package.These arguments are particularly useful
for mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?marginaleffects} documentation for a non-exhaustive list of available
arguments.}
}
\description{
\code{deltamethod} is a function to get a first-order approximate standard error
for a nonlinear function of a vector of random variables with known or
estimated covariance matrix. \code{\link{deltamethod}} emulates the behavior of the
excellent and well-established \link[car:deltaMethod]{car::deltaMethod} and \link[car:linearHypothesis]{car::linearHypothesis}
functions, but it supports more models, requires fewer dependencies, and
offers some convenience features like shortcuts for robust standard errors.
}
\examples{
library(marginaleffects)
mod <- lm(mpg ~ hp + wt + factor(cyl), data = mtcars)

# When `FUN` and `hypothesis` are `NULL`, `deltamethod()` returns a data.frame of parameters
deltamethod(mod)

# Test of equality between coefficients
deltamethod(mod, "hp = wt")

# Non-linear function
deltamethod(mod, "exp(hp + wt) = 0.1")

# Robust standard errors
deltamethod(mod, "hp = wt", vcov = "HC3")

# b1, b2, ... shortcuts can be used to identify the position of the
# parameters of interest in the output of FUN
deltamethod(mod, "b2 = b3")

# term names with special characters have to be enclosed in backticks
deltamethod(mod, "`factor(cyl)6` = `factor(cyl)8`")

# The `FUN` argument can be used to compute standard errors for fitted values
mod <- glm(am ~ hp + mpg, data = mtcars, family = binomial)

f <- function(x) predict(x, type = "link", newdata = mtcars)
p <- deltamethod(mod, FUN = f)
head(p)

f <- function(x) predict(x, type = "response", newdata = mtcars)
p <- deltamethod(mod, FUN = f)
head(p)

}
