

The `marginaleffects` package for `R` and `Python` offers a single point
of entry to easily interpret the results of [over 100 classes of
models,](https://marginaleffects.com/bonus/supported_models.html) using
a simple and consistent user interface.

This package comes with a free full-length online book, with extensive
tutorials: <https://marginaleffects.com>

The package’s benefits include:

- *Powerful:* It can compute and plot predictions; comparisons
  (contrasts, risk ratios, etc.); slopes; and conduct hypothesis and
  equivalence tests for over 100 different classes of models in `R`.
- *Simple:* All functions share a simple and unified interface.
- *Documented*: Each function is thoroughly documented with abundant
  examples. The Marginal Effects Zoo website includes 20,000+ words of
  vignettes and case studies.
- *Efficient:* [Some
  operations](https://marginaleffects.com/bonus/performance.html) can be
  up to 1000 times faster and use 30 times less memory than with the
  `margins` package.  
- *Valid:* When possible, [numerical results are
  checked](https://marginaleffects.com/bonus/supported_models.html)
  against alternative software like `Stata` or other `R` packages.
- *Thin:* The `R` package requires relatively few dependencies.
- *Standards-compliant:* `marginaleffects` follows “tidy” principles and
  returns simple data frames that work with all standard `R` functions.
  The outputs are easy to program with and feed to other packages like
  [`ggplot2`](https://marginaleffects.com/bonus/plot.html) or
  [`modelsummary`.](https://marginaleffects.com/bonus/tables.html)
- *Extensible:* Adding support for new models is very easy, often
  requiring less than 10 lines of new code. Please submit [feature
  requests on
  Github.](https://github.com/vincentarelbundock/marginaleffects/issues)
- *Active development*: Bugs are fixed promptly.

To cite marginaleffects in publications use:

Arel-Bundock V, Greifer N, Heiss A (2024). “How to Interpret Statistical
Models Using marginaleffects for R and Python.” *Journal of Statistical
Software*, *111*(9), 1-32. 

A BibTeX entry for LaTeX users is

@Article{, title = {How to Interpret Statistical Models Using
{marginaleffects} for {R} and {Python}}, author = {Vincent Arel-Bundock
and Noah Greifer and Andrew Heiss}, journal = {Journal of Statistical
Software}, year = {2024}, volume = {111}, number = {9}, pages = {1–32},
doi = {10.18637/jss.v111.i09}, }
