% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winOddsPlots.R
\name{component_plot.maraca}
\alias{component_plot.maraca}
\title{Generic function to create a plot showing the components used in
calculating win odds (wins and ties) separately for each
outcome directly from a maraca object.
Note that for this plot, when creating the maraca object using the maraca()
function, the argument "compute_win_odds" has to be set to TRUE.
Check the vignette "Maraca Plots - Plotting win odds" for more details.}
\usage{
\method{component_plot}{maraca}(x, theme = "maraca", ...)
}
\arguments{
\item{x}{an object of S3 class 'maraca'.}

\item{theme}{Choose theme to style the plot. The default theme is "maraca".
Options are "maraca", "color1", "color2" and none".
For more details, check the vignette called
"Maraca Plots - Plotting win odds".}

\item{\dots}{not used}
}
\value{
Component plot as a ggplot2 object.
}
\description{
Generic function to create a plot showing the components used in
calculating win odds (wins and ties) separately for each
outcome directly from a maraca object.
Note that for this plot, when creating the maraca object using the maraca()
function, the argument "compute_win_odds" has to be set to TRUE.
Check the vignette "Maraca Plots - Plotting win odds" for more details.
}
\examples{

data(hce_scenario_a)

maraca_dat <- maraca(data = hce_scenario_a,
                     step_outcomes = c("Outcome I", "Outcome II",
                                      "Outcome III", "Outcome IV"),
                     last_outcome = "Continuous outcome",
                     fixed_followup_days = 3 * 365,
                     column_names = c(outcome = "GROUP",
                                      arm = "TRTP",
                                      value = "AVAL0"),
                     arm_levels = c(active = "Active",
                                    control = "Control"),
                     compute_win_odds = TRUE
                     )

component_plot(maraca_dat)

}
