% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_grad.R
\name{mf_grad}
\alias{mf_grad}
\title{Plot graduated symbols}
\usage{
mf_grad(
  x,
  var,
  breaks = "quantile",
  nbreaks = 3,
  col = "tomato4",
  border = getOption("mapsf.fg"),
  pch = 21,
  cex,
  lwd,
  leg_pos = mf_get_leg_pos(x),
  leg_title = var,
  leg_title_cex = 0.8,
  leg_val_cex = 0.6,
  leg_val_rnd = 2,
  leg_frame = FALSE,
  leg_adj = c(0, 0),
  leg_size = 1,
  leg_border = border,
  leg_box_cex = c(1, 1),
  leg_fg = getOption("mapsf.fg"),
  leg_bg = getOption("mapsf.bg"),
  leg_frame_border = getOption("mapsf.fg"),
  add = TRUE
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{breaks}{either a numeric vector with the actual breaks, or a classification method name (see \link{mf_get_breaks} and Details)}

\item{nbreaks}{number of classes}

\item{col}{color}

\item{border}{border color}

\item{pch}{pch (point type) for symbols}

\item{cex}{cex (point size) for symbols}

\item{lwd}{border width}

\item{leg_pos}{position of the legend, one of 'topleft', 'top','topright', 'right', 'bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). If leg_pos = NA then the legend is not plotted. If leg_pos = 'interactive' click onthe map to choose the legend position.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_val_rnd}{number of decimal places of the values in the legend}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{leg_adj}{adjust the postion of the legend in x and y directions}

\item{leg_size}{size of the legend; 2 means two times bigger}

\item{leg_border}{symbol border color(s)}

\item{leg_box_cex}{width and height size expansion of boxes}

\item{leg_fg}{color of the legend foreground}

\item{leg_bg}{color of the legend backgournd}

\item{leg_frame_border}{border color of the legend frame}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}
}
\value{
x is (invisibly) returned.
}
\description{
Plot graduated symbols based on quantitative data.
}
\details{
Breaks defined by a numeric vector or a classification method are
left-closed: breaks defined by \code{c(2, 5, 10, 15, 20)}
will be mapped as [2 - 5[, [5 - 10[, [10 - 15[, [15 - 20].
The "jenks" method is an exception and has to be right-closed.
Jenks breaks computed as \code{c(2, 5, 10, 15, 20)}
will be mapped as [2 - 5], ]5 - 10], ]10 - 15], ]15 - 20].
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq)
mf_map(mtq, "POP", "grad", pch = 22)
}
\keyword{internal}
