% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_mat.R
\name{make_mat_mappoly}
\alias{make_mat_mappoly}
\title{Subset recombination fraction matrices}
\usage{
make_mat_mappoly(input.mat, input.seq)
}
\arguments{
\item{input.mat}{an object of class \code{mappoly.rf.matrix}}

\item{input.seq}{an object of class \code{mappoly.sequence}, with 
a sequence of markers contained in \code{input.mat}}
}
\value{
an object of class \code{mappoly.rf.matrix},
which is a subset of \code{'input.mat'}. 
See \code{\link[mappoly]{rf_list_to_matrix}} for details
}
\description{
Get a subset of an object of class \code{mappoly.rf.matrix}, i.e.
 recombination fraction and LOD score matrices based in a
 sequence of markers.
}
\examples{
    # sequence with 20 markers
    mrk.seq<-make_seq_mappoly(hexafake, 1:20)
    mrk.pairs<-est_pairwise_rf(input.seq = mrk.seq,
                               verbose=TRUE)
    ## Full recombination fraction matrix
    mat<-rf_list_to_matrix(input.twopt=mrk.pairs)
    plot(mat)
    ## Matrix subset
    id <- make_seq_mappoly(hexafake, 1:10)
    mat.sub<-make_mat_mappoly(mat, id)
    plot(mat.sub)
   
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
