% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{cluster_options}
\alias{cluster_options}
\title{Prepare cluster options for circle layers}
\usage{
cluster_options(
  max_zoom = 14,
  cluster_radius = 50,
  color_stops = c("#51bbd6", "#f1f075", "#f28cb1"),
  radius_stops = c(20, 30, 40),
  count_stops = c(0, 100, 750),
  circle_blur = NULL,
  circle_opacity = NULL,
  circle_stroke_color = NULL,
  circle_stroke_opacity = NULL,
  circle_stroke_width = NULL
)
}
\arguments{
\item{max_zoom}{The maximum zoom level at which to cluster points.}

\item{cluster_radius}{The radius of each cluster when clustering points.}

\item{color_stops}{A vector of colors for the circle color step expression.}

\item{radius_stops}{A vector of radii for the circle radius step expression.}

\item{count_stops}{A vector of point counts for both color and radius step expressions.}

\item{circle_blur}{Amount to blur the circle.}

\item{circle_opacity}{The opacity of the circle.}

\item{circle_stroke_color}{The color of the circle's stroke.}

\item{circle_stroke_opacity}{The opacity of the circle's stroke.}

\item{circle_stroke_width}{The width of the circle's stroke.}
}
\value{
A list of cluster options.
}
\description{
This function creates a list of options for clustering circle layers.
}
\examples{
cluster_options(
    max_zoom = 14,
    cluster_radius = 50,
    color_stops = c("#51bbd6", "#f1f075", "#f28cb1"),
    radius_stops = c(20, 30, 40),
    count_stops = c(0, 100, 750),
    circle_blur = 1,
    circle_opacity = 0.8,
    circle_stroke_color = "#ffffff",
    circle_stroke_width = 2
)
}
