% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortestpath.R
\name{shortestpath}
\alias{shortestpath}
\title{Find Shortest Path using Floyd-Warshall Algorithm}
\usage{
shortestpath(dist)
}
\arguments{
\item{dist}{either an \eqn{(n\times n)} matrix or a \code{dist} class object.}
}
\value{
an \eqn{(n\times n)} matrix containing pairwise shortest path length.
}
\description{
This is a fast implementation of Floyd-Warshall algorithm to find the
shortest path in a pairwise sense using \code{RcppArmadillo}. A logical input
is also accepted. The given matrix should contain pairwise distance values \eqn{d_{i,j}} where 
\eqn{0} means there exists no path for node \eqn{i} and {j}.
}
\examples{
## simple example : a ring graph
#  edges exist for pairs
A = array(0,c(10,10))
for (i in 1:9){
  A[i,i+1] = 1
  A[i+1,i] = 1
}
A[10,1] <- A[1,10] <- 1

# compute shortest-path and show the matrix
sdA <- shortestpath(A)

# visualize
opar <- par(no.readonly=TRUE)
par(pty="s")
image(sdA, main="shortest path length for a ring graph")
par(opar)

}
\references{
\insertRef{floyd_algorithm_1962}{maotai}

\insertRef{warshall_theorem_1962}{maotai}
}
