% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_reformed.R
\name{manip_project}
\alias{manip_project}
\alias{to_mode1}
\alias{to_mode2}
\alias{to_ties}
\title{Modifying networks projection}
\usage{
to_mode1(.data, similarity = c("count", "jaccard", "rand", "pearson", "yule"))

to_mode2(.data, similarity = c("count", "jaccard", "rand", "pearson", "yule"))

to_ties(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{similarity}{Method for establishing ties,
currently "count" (default), "jaccard", or "rand".
"count" calculates the number of coinciding ties,
and can be interpreted as indicating the degree of opportunities
between nodes.
"jaccard" uses this count as the numerator in a proportion,
where the denominator consists of any cell where either node has a tie.
It can be interpreted as opportunity weighted by participation.
"rand", or the Simple Matching Coefficient,
is a proportion where the numerator consists of the count of cells where
both nodes are present or both are absent,
over all possible cells.
It can be interpreted as the (weighted) degree of behavioral mirroring
between two nodes.
"pearson" (Pearson's coefficient) and "yule" (Yule's Q)
produce correlations for valued and binary data, respectively.
Note that Yule's Q has a straightforward interpretation related to the odds ratio.}
}
\value{
All \code{to_} functions return an object of the same class as that provided.
So passing it an igraph object will return an igraph object
and passing it a network object will return a network object,
with certain modifications as outlined for each function.
}
\description{
These functions offer tools for projecting manynet-consistent data:
\itemize{
\item \code{to_mode1()} projects a two-mode network to a one-mode network
of the first node set's (e.g. rows) joint affiliations to nodes in the second node set (columns).
\item \code{to_mode2()} projects a two-mode network to a one-mode network
of the second node set's (e.g. columns) joint affiliations to nodes in the first node set (rows).
\item \code{to_ties()} projects a network to one where the ties become nodes and incident nodes become their ties.
}
}
\details{
Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrrrr}{
    \tab data.frame \tab igraph \tab matrix \tab network \tab tbl_graph \cr
   to_mode1 \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_mode2 \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_ties \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
}
}
\examples{
to_mode1(ison_southern_women)
to_mode2(ison_southern_women)
#graphr(to_mode1(ison_southern_women))
#graphr(to_mode2(ison_southern_women))
to_ties(ison_adolescents)
#graphr(to_ties(ison_adolescents))
}
\seealso{
Other modifications: 
\code{\link{manip_as}},
\code{\link{manip_correlation}},
\code{\link{manip_deformat}},
\code{\link{manip_from}},
\code{\link{manip_levels}},
\code{\link{manip_miss}},
\code{\link{manip_nodes}},
\code{\link{manip_paths}},
\code{\link{manip_permutation}},
\code{\link{manip_preformat}},
\code{\link{manip_reformat}},
\code{\link{manip_scope}},
\code{\link{manip_split}},
\code{\link{manip_ties}}
}
\concept{modifications}
