% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/member_components.R
\name{member_components}
\alias{member_components}
\alias{node_in_component}
\alias{node_in_weak}
\alias{node_in_strong}
\title{Component partitioning algorithms}
\usage{
node_in_component(.data)

node_in_weak(.data)

node_in_strong(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
These functions create a vector of nodes' memberships in
components or degrees of coreness:
\itemize{
\item \code{node_in_component()} assigns nodes' component membership
using edge direction where available.
\item \code{node_in_weak()} assigns nodes' component membership
ignoring edge direction.
\item \code{node_in_strong()} assigns nodes' component membership
based on edge direction.
}

In graph theory, components, sometimes called connected components,
are induced subgraphs from partitioning the nodes into disjoint sets.
All nodes that are members of the same partition as \emph{i} are reachable
from \emph{i}.

For directed networks,
strongly connected components consist of subgraphs where there are paths
in each direction between member nodes.
Weakly connected components consist of subgraphs where there is a path
in either direction between member nodes.

Coreness captures the maximal subgraphs in which each vertex has at least
degree \emph{k}, where \emph{k} is also the order of the subgraph.
As described in \code{igraph::coreness},
a node's coreness is \emph{k} if it belongs to the \emph{k}-core
but not to the (\emph{k}+1)-core.
}
\examples{
node_in_component(ison_monastery_esteem)
}
\seealso{
Other memberships: 
\code{\link{mark_core}},
\code{\link{member_cliques}},
\code{\link{member_community_hier}},
\code{\link{member_community_non}},
\code{\link{member_equivalence}}
}
\concept{memberships}
