% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_is.R
\name{is}
\alias{is}
\alias{is_manynet}
\alias{is_graph}
\alias{is_edgelist}
\alias{is_list}
\alias{is_longitudinal}
\alias{is_dynamic}
\title{Marking networks classes}
\usage{
is_manynet(.data)

is_graph(.data)

is_edgelist(.data)

is_list(.data)

is_longitudinal(.data)

is_dynamic(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\value{
TRUE if the condition is met, or FALSE otherwise.
}
\description{
These functions implement logical tests for networks' classes.
\itemize{
\item \code{is_manynet()} marks a network TRUE if it is compatible with \code{{manynet}} functions.
\item \code{is_edgelist()} marks a network TRUE if it is an edgelist.
\item \code{is_graph()} marks a network TRUE if it contains graph-level information.
\item \code{is_list()} marks a network TRUE if it is a (non-igraph) list of networks,
for example a set of ego networks or a dynamic or longitudinal set of networks.
\item \code{is_longitudinal()} marks a network TRUE if it contains longitudinal, panel data.
\item \code{is_dynamic()} marks a network TRUE if it contains dynamic, time-stamped data
}

All \verb{is_*()} functions return a logical scalar (TRUE or FALSE).
}
\examples{
is_manynet(create_filled(2))
is_graph(create_star(2))
is_edgelist(matrix(c(2,2), 1, 2))
is_edgelist(as_edgelist(matrix(c(2,2), 1, 2)))
is_longitudinal(create_tree(5, 3))
is_dynamic(create_tree(3))
}
\seealso{
Other marking: 
\code{\link{features}},
\code{\link{is_format}}
}
\concept{marking}
