% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_indirect_list.R
\name{print.indirect_list}
\alias{print.indirect_list}
\title{Print an 'indirect_list' Class
Object}
\usage{
\method{print}{indirect_list}(x, digits = 3, annotation = TRUE, ...)
}
\arguments{
\item{x}{The output of
\code{\link[=many_indirect_effects]{many_indirect_effects()}}.}

\item{digits}{Number of digits to
display. Default is 3.}

\item{annotation}{Logical. Whether
the annotation after the table of
effects is to be printed. Default is
\code{TRUE.}}

\item{...}{Other arguments. Not used.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of the
output of \code{\link[=many_indirect_effects]{many_indirect_effects()}}.
}
\examples{

library(lavaan)
data(data_serial_parallel)
mod <-
"
m11 ~ x + c1 + c2
m12 ~ m11 + x + c1 + c2
m2 ~ x + c1 + c2
y ~ m12 + m2 + m11 + x + c1 + c2
"
fit <- sem(mod, data_serial_parallel,
           fixed.x = FALSE)
# All indirect paths from x to y
paths <- all_indirect_paths(fit,
                           x = "x",
                           y = "y")
paths
# Indirect effect estimates
out <- many_indirect_effects(paths,
                             fit = fit)
out


}
\seealso{
\code{\link[=many_indirect_effects]{many_indirect_effects()}}
}
