% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_indirect_list.R
\name{confint.indirect_list}
\alias{confint.indirect_list}
\title{Confidence Intervals of
Indirect Effects in an 'indirect_list'
Object}
\usage{
\method{confint}{indirect_list}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{The output of
\code{\link[=many_indirect_effects]{many_indirect_effects()}}.}

\item{parm}{Ignored for now.}

\item{level}{The level of confidence,
default is .95, returning the 95\%
confidence interval.}

\item{...}{Additional arguments.
Ignored by the function.}
}
\value{
A two-column data frame.
The columns are the limits of
the confidence intervals.
}
\description{
Return the  bootstrap
confidence intervals of the indirect
effects
stored in the output of
\code{\link[=many_indirect_effects]{many_indirect_effects()}}.
}
\details{
It extracts and returns the
stored bootstrap confidence interval
if available.
}
\examples{

library(lavaan)
data(data_serial_parallel)
mod <-
"
m11 ~ x + c1 + c2
m12 ~ m11 + x + c1 + c2
m2 ~ x + c1 + c2
y ~ m12 + m2 + m11 + x + c1 + c2
"
fit <- sem(mod, data_serial_parallel,
           fixed.x = FALSE)
# All indirect paths from x to y
paths <- all_indirect_paths(fit,
                           x = "x",
                           y = "y")
paths
# Indirect effect estimates
# R should be 2000 or even 5000 in real research
# parallel should be used in real research.
fit_boot <- do_boot(fit, R = 45, seed = 8974,
                    parallel = FALSE)
out <- many_indirect_effects(paths,
                             fit = fit,
                             boot_ci = TRUE,
                             boot_out = fit_boot)
out
confint(out)



}
\seealso{
\code{\link[=many_indirect_effects]{many_indirect_effects()}}
}
