% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_models}
\alias{fit_models}
\title{Fit several models with different response variables}
\usage{
fit_models(
  df = NULL,
  yname = NULL,
  xname = NULL,
  modeltype = NULL,
  drop_non_numeric = FALSE,
  ...
)
}
\arguments{
\item{df}{A data.frame object}

\item{yname}{The outcome variable}

\item{xname}{The predictor variable(s)}

\item{modeltype}{A character specifying the model type e.g lm for 
linear model}

\item{drop_non_numeric}{Should non numeric columns be dropped? 
Defaults to FALSE}

\item{...}{Other arguments to specific model types.}
}
\value{
A list of model objects that can be used later.
}
\description{
Fit several models with different response variables
}
\examples{
data("yields", package="manymodelr")
fit_models(df=yields,yname=c("height","yield"),xname="weight",modeltype="lm")
#many model types
fit_models(df=yields,yname=c("height","yield"),xname="weight",
modeltype=c("lm", "glm"))
}
