% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_ranges}
\alias{compare_ranges}
\title{Compare ranges of variables in 'many' data}
\usage{
compare_ranges(datacube, dataset = "all", variable)
}
\arguments{
\item{datacube}{A datacube from one of the many packages.}

\item{dataset}{A dataset in a datacube from one of the many packages.
By default, "all".
That is, all datasets in the datacube are used.
To select two or more datasets, please declare them as a vector.}

\item{variable}{Please declare a variable present in one or more
datasets in the 'many' datacube.
For multiple variables, please declare variable names as a vector.}
}
\value{
\code{compare_ranges()} returns a tibble with information about the minimal,
maximal, average, and median values for selected variables in datacubes.
}
\description{
Compare ranges of variables in 'many' data
}
\details{
\code{compare_ranges()} compares the number of observations, variables,
the earliest and latest date in each dataset in a 'many' datacube.
}
\examples{
\donttest{
compare_ranges(emperors, variable = c("Begin", "End"))
}
}
\seealso{
Other compare_: 
\code{\link{compare_categories}()},
\code{\link{compare_dimensions}()},
\code{\link{compare_missing}()},
\code{\link{compare_overlap}()}
}
\concept{compare_}
