% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_functions.R
\name{batch_analysis_years}
\alias{batch_analysis_years}
\title{Batch Analysis Across Multiple Years}
\usage{
batch_analysis_years(
  years,
  scale = "huc8",
  nutrients = c("nitrogen", "phosphorus"),
  include_wwtp = TRUE,
  output_base_dir = tempdir(),
  create_comparative_plots = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{years}{Numeric vector. Years to analyze}

\item{scale}{Character. Spatial scale: "county", "huc8", or "huc2"}

\item{nutrients}{Character vector. Nutrients to analyze}

\item{include_wwtp}{Logical. Whether to include WWTP (only available for 2007-2016 built-in)}

\item{output_base_dir}{Character. Base output directory}

\item{create_comparative_plots}{Logical. Whether to create year-over-year comparisons}

\item{verbose}{Logical. Whether to print progress}

\item{...}{Additional arguments passed to run_builtin_analysis}
}
\value{
List of results for each year
}
\description{
Run manureshed analysis across multiple years with consistent parameters
}
\examples{
\donttest{
# Analyze trends with WWTP for subset of supported range
batch_results <- batch_analysis_years(
  years = 2010:2012,  # Use smaller range for examples
  scale = "huc8",
  nutrients = "nitrogen",
  include_wwtp = TRUE
)

# Historical analysis without WWTP
historical_results <- batch_analysis_years(
  years = 1990:1992,  # Use smaller range
  scale = "county",
  nutrients = c("nitrogen", "phosphorus"),
  include_wwtp = FALSE
)

# Mixed analysis: some years with WWTP, some without
mixed_results <- batch_analysis_years(
  years = c(2005, 2010, 2015),  # 2010,2015 will have WWTP
  scale = "huc8",
  nutrients = "nitrogen",
  include_wwtp = TRUE  # Will only apply to 2010,2015
)
}
}
