% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agricultural_functions.R
\name{agri_classify_nitrogen_custom}
\alias{agri_classify_nitrogen_custom}
\title{Classify Agricultural Nitrogen Status with Custom Efficiency Factor}
\usage{
agri_classify_nitrogen_custom(
  data,
  cropland_threshold,
  scale = "huc8",
  n_efficiency = 0.5
)
}
\arguments{
\item{data}{Data frame with processed agricultural data}

\item{cropland_threshold}{Numeric. Threshold for excluding small cropland areas}

\item{scale}{Character. Spatial scale for within-unit classification}

\item{n_efficiency}{Numeric. Nitrogen efficiency factor (default: 0.5, range: 0-1)}
}
\value{
Data frame with nitrogen classification added
}
\description{
Classify spatial units based on nitrogen balance with user-specified efficiency factor.
This function allows sensitivity analysis by varying the nitrogen efficiency assumption.
The default value of 0.5 represents typical losses during nutrient cycling, uptake, and
application, but regional conditions may warrant different values.
}
\examples{
\donttest{
# Load and process data first
nugis_data <- load_builtin_nugis("county", 2016)
processed_data <- agri_process_nugis(nugis_data, "county")
cropland_threshold <- 500 * 2.47105  # 500 ha in acres

# Standard analysis with default 0.5 efficiency
results_default <- agri_classify_nitrogen_custom(
  processed_data, cropland_threshold = cropland_threshold, n_efficiency = 0.5
)

# Sensitivity analysis with higher efficiency (e.g., improved management)
results_high <- agri_classify_nitrogen_custom(
  processed_data, cropland_threshold = cropland_threshold, n_efficiency = 0.7
)

# Conservative analysis with lower efficiency
results_low <- agri_classify_nitrogen_custom(
  processed_data, cropland_threshold = cropland_threshold, n_efficiency = 0.3
)

# Compare classification changes across efficiency scenarios
table(results_default$N_class)
table(results_high$N_class)
table(results_low$N_class)
}
}
