% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EuManifold.R, R/General.R, R/HSManifold.R,
%   R/SOManifold.R, R/SPDManifolds.R, R/SphereManifold.R
\name{rieExp.Euclidean}
\alias{rieExp.Euclidean}
\alias{rieExp}
\alias{rieExp.L2}
\alias{rieExp.HS}
\alias{rieExp.Dens}
\alias{rieExp.SO}
\alias{rieExp.LogEu}
\alias{rieExp.AffInv}
\alias{rieExp.Sphere}
\title{Riemannian exponential map}
\usage{
\method{rieExp}{Euclidean}(mfd, p, V, ...)

rieExp(mfd, p, V, ...)

\method{rieExp}{L2}(mfd, p, V, ...)

\method{rieExp}{HS}(mfd, p, V, ...)

\method{rieExp}{Dens}(mfd, p, V, ...)

\method{rieExp}{SO}(mfd, p, V, tol = 1e-10, ...)

\method{rieExp}{LogEu}(mfd, p, V, ...)

\method{rieExp}{AffInv}(mfd, p, V, ...)

\method{rieExp}{Sphere}(mfd, p, V, ...)
}
\arguments{
\item{mfd}{A manifold object created by \code{\link{createM}}}

\item{p, V}{Matrices with n columns. The exponential map of each column in V is calculated w.r.t. the corresponding column in p.}

\item{...}{Passed into specific methods}

\item{tol}{Tolerance for `rieExp.SO`}
}
\value{
A matrix in which columns correspond to points on the manifold
}
\description{
Riemannian exponential map
}
\section{Methods (by class)}{
\itemize{
\item \code{rieExp(Euclidean)}: Method

\item \code{rieExp(L2)}: Method

\item \code{rieExp(HS)}: Method

\item \code{rieExp(Dens)}: Method

\item \code{rieExp(SO)}: Method

\item \code{rieExp(LogEu)}: Method

\item \code{rieExp(AffInv)}: Method

\item \code{rieExp(Sphere)}: Method

}}
