% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EuManifold.R, R/General.R, R/HSManifold.R,
%   R/SOManifold.R, R/SPDManifolds.R, R/SphereManifold.R
\name{projectTangent.Euclidean}
\alias{projectTangent.Euclidean}
\alias{projectTangent}
\alias{projectTangent.L2}
\alias{projectTangent.HS}
\alias{projectTangent.Dens}
\alias{projectTangent.SO}
\alias{projectTangent.SPD}
\alias{projectTangent.Sphere}
\title{Project data points in the ambient space onto the tangent space}
\usage{
\method{projectTangent}{Euclidean}(mfd, p, X, projMatOnly = FALSE, ...)

projectTangent(mfd, p, X, projMatOnly, ...)

\method{projectTangent}{L2}(mfd, p, X, projMatOnly = FALSE, ...)

\method{projectTangent}{HS}(mfd, p, X, projMatOnly = FALSE, ...)

\method{projectTangent}{Dens}(mfd, p, X, projMatOnly, ...)

\method{projectTangent}{SO}(mfd, p, X, projMatOnly = FALSE, ...)

\method{projectTangent}{SPD}(mfd, p, X, projMatOnly = FALSE, ...)

\method{projectTangent}{Sphere}(mfd, p, X, projMatOnly = FALSE, ...)
}
\arguments{
\item{mfd}{A manifold object created by \code{\link{createM}}}

\item{p}{A vector containing the base point on the manifold. Data X will be projected onto the tangent space of p.}

\item{X}{A vector or a matrix containing the data points in terms of the coordinates in the ambient space.}

\item{projMatOnly}{Whether to only return the projection matrix (FALSE) or the projected data points (TRUE, the default)}

\item{...}{Passed into specific methods}
}
\value{
A matrix in which columns correspond to points on the tangent spaces
}
\description{
Project data points in the ambient space onto the tangent space
}
\section{Methods (by class)}{
\itemize{
\item \code{projectTangent(Euclidean)}: Method

\item \code{projectTangent(L2)}: Method

\item \code{projectTangent(HS)}: Method

\item \code{projectTangent(Dens)}: Method

\item \code{projectTangent(SO)}: Method

\item \code{projectTangent(SPD)}: Method

\item \code{projectTangent(Sphere)}: Method

}}
