/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.GraphAddEdgeEvent;
import salvo.jesus.graph.GraphAddVertexEvent;
import salvo.jesus.graph.GraphRemoveEdgeEvent;
import salvo.jesus.graph.GraphRemoveVertexEvent;
import salvo.jesus.graph.StopAtVisitor;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.algorithm.DepthFirstGraphTraversal;
import salvo.jesus.graph.algorithm.GraphTraversal;
import salvo.jesus.graph.listener.NullGraphListener;

public class ConnectedSetListener
extends NullGraphListener {
    private Graph m_graph;
    private List m_connectedSetList;

    public ConnectedSetListener(Graph graph) {
        this.m_graph = graph;
        this.m_connectedSetList = new ArrayList();
        DepthFirstGraphTraversal traversal = new DepthFirstGraphTraversal(this.m_graph);
        Iterator vertexIter = this.m_graph.getVerticesIterator();
        while (vertexIter.hasNext()) {
            Vertex v = (Vertex)vertexIter.next();
            HashSet connectedSet = this.getModifiableConnectedSet(v);
            if (connectedSet != null) continue;
            connectedSet = new HashSet(((GraphTraversal)traversal).traverse(v));
            this.m_connectedSetList.add(connectedSet);
        }
        this.m_graph.addListener(this);
    }

    public Set getConnectedSet(Vertex v) {
        return Collections.unmodifiableSet(this.getModifiableConnectedSet(v));
    }

    public Collection getConnectedSets() {
        ArrayList c = new ArrayList();
        Iterator iter = this.m_connectedSetList.iterator();
        while (iter.hasNext()) {
            Set s = (Set)iter.next();
            c.add(Collections.unmodifiableSet(s));
        }
        return Collections.unmodifiableCollection(c);
    }

    private Set getModifiableConnectedSet(Vertex v) {
        for (int i = 0; i < this.m_connectedSetList.size(); ++i) {
            Set set = (Set)this.m_connectedSetList.get(i);
            if (!set.contains(v)) continue;
            return set;
        }
        return null;
    }

    public void afterEdgeAdded(GraphAddEdgeEvent event) {
        Set setB;
        Edge edge = event.getEdge();
        Set setA = this.getModifiableConnectedSet(edge.getVertexA());
        if (setA == (setB = this.getModifiableConnectedSet(edge.getVertexB()))) {
            return;
        }
        if (setA.size() < setB.size()) {
            setB.addAll(setA);
            this.m_connectedSetList.remove(setA);
        } else {
            setA.addAll(setB);
            this.m_connectedSetList.remove(setB);
        }
    }

    public void afterVertexAdded(GraphAddVertexEvent event) {
        Vertex v = event.getVertex();
        HashSet<Vertex> newSet = new HashSet<Vertex>();
        newSet.add(v);
        this.m_connectedSetList.add(newSet);
    }

    public void afterEdgeRemoved(GraphRemoveEdgeEvent event) {
        Edge edge = event.getEdge();
        Vertex v1 = edge.getVertexA();
        Vertex v2 = edge.getVertexB();
        StopAtVisitor visitor = new StopAtVisitor(v1);
        DepthFirstGraphTraversal traversal = new DepthFirstGraphTraversal(this.m_graph);
        List v2ConnectedList = ((GraphTraversal)traversal).traverse(v2, visitor);
        if (visitor.wasFound()) {
            return;
        }
        Set v1ConnectedSet = this.getModifiableConnectedSet(v1);
        HashSet v2ConnectedSet = new HashSet(v2ConnectedList);
        v1ConnectedSet.removeAll(v2ConnectedSet);
        this.m_connectedSetList.add(v2ConnectedSet);
    }

    public void afterVertexRemoved(GraphRemoveVertexEvent event) {
        Vertex v = event.getVertex();
        this.m_connectedSetList.remove(this.getModifiableConnectedSet(v));
    }
}

