% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_prior_object_functions.R
\name{mc}
\alias{mc}
\title{Define latent component}
\usage{
mc(
  label,
  model = "iid",
  constr = NULL,
  lin_constr = FALSE,
  Cmatrix = NULL,
  graph = NULL,
  ...
)
}
\arguments{
\item{label}{Name of the component (short names is an advantage as they are used in the app), no default (MUST be provided)}

\item{model}{Type of model, default is "iid" (see list of models: \link[makemyprior]{makemyprior_models}, \code{makemyprior_models("latent")}).}

\item{constr}{Sum-to-zero constraints on component (default TRUE)}

\item{lin_constr}{Linear sum-to-zero constraint, TRUE/FALSE (only for rw2 and only for Stan)}

\item{Cmatrix}{Precision for this component when \code{model = "generic0"}.
We recommend that the matrixes are scaled to the typical variance of the corresponding covariance matrix is 1.
This can be done with \link[makemyprior]{scale_precmat} before sending matrix to \link[makemyprior]{mc}.}

\item{graph}{Path to graph file for besag effect (see details).}

\item{...}{Additional arguments used for inference. For inference with \link[rstan]{rstan} or \link[INLA]{inla},
the following is useful (especially for the Besag model):
\describe{
  \item{\code{scale.model}}{if TRUE, the models are scaled so the geometric mean of the variance (typical variance) is 1}
}
And some additional arguments that can be used by \link[INLA]{inla}. Useful arguments include:
\describe{
  \item{\code{rankdef}}{number defining rank deficiency of the model}
  \item{\code{extraconstr}}{extra linear constraints (in addition to \code{constr})}
}
See \link[INLA]{f} for details.}
}
\value{
For specifying details on this latent component.
}
\description{
Function for defining a latent component for the HD prior package. All model components must be specified, and if an HD
prior is used, this is specified later. See \link[makemyprior]{make_prior} for more details and examples.
}
\details{
The graph argument is a path to a file describing neighbouring relationship on the following form:
First row: number of elements
The rest: First number is the index of this element, second is the number of neighbours, the rest is the index numbers
of all neighbours for this element.
If element 1 and 4 are neighbours, 1 should have 4 in its neighbour list, and 4 should have 1.
}
\examples{
\dontrun{

vignette("make_prior", package = "makemyprior")
}

}
\keyword{formula}
