% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{query}
\alias{query}
\title{Search-like function that can obtain linked data from distinct models.}
\usage{
query(target, projectName, queryTerms = list(), format = c("list", "df"), ...)
}
\arguments{
\item{target}{A list, which can be created using \code{\link{magmaRset}}, containing your authorization 'token' (a string), a 'url' of magma to target (a string), and optional 'opts' for specifying additions parameters for curl requests (a named list).}

\item{projectName}{Single string. The name of the project you would like to interact with. For options, see \code{\link{retrieveProjects}}.}

\item{queryTerms}{A list of strings where list elements are query predicates and verbs. See \url{https://mountetna.github.io/magma.html#query} for details.}

\item{format}{Either "list" or "df" (=dataframe). This sets the desired output format. The list option is the more raw form.}

\item{...}{Additional parameters passed along to the internal `.retrieve()`, `.query()`, or `.update()` functions,
for troubleshooting or advanced-user purposes only: \itemize{
\item \code{request.only} (Logical) & \code{json.params.only} (Logical) which 1) stop the function before its main curl request to magma and 2) returns the values that would have been sent to magma in either of two formats.
\item \code{verbose} (Logical) sets whether to report the status of the curl request after it is performed.
}}
}
\value{
A list, default, if \code{format == "list"},

OR A dataframe conversion if \code{format = "df"}
}
\description{
Analogous to the '/query' function of magma.
}
\details{
This function initially mimics the activity of the magma's /query functionality,
which is documented here \url{https://mountetna.github.io/magma.html#query}.

Afterwards, the json list output of magma/query is converted into an R list, and then the \code{format} input determines whether it should be wrangled further:
\itemize{
\item \code{format = "list"}, default: R list output directly.
\item \code{format = "df"}: R list converted into a dataframe where data comes from the list$answer and column names come from the list$format
}
}
\examples{

if (interactive()) {
    # First, we use magmaRset to create an object which will tell other magmaR
    #  functions our authentication token (as well as some other optional bits).
    # When run in this way, it will ask you to give your token.
    magma <- magmaRset()
    
    ### To obtain the 'group' attribute, from the subject-model, that are
    #   associated with records of the rna_seq-model:

    # "Raw" output of query:
    query_list <- query(
        target = magma,
        projectName = "example",
        queryTerms = 
            list('rna_seq',
                 '::all',
                 'biospecimen',
                 'subject',
                 'group'))
    print(query_list)
                 
    # Or instead re-formatted to a dataframe, which may be easier for
    #   downstream applications in R:
    query_df <- query(
        target = magma,
        projectName = "example",
        queryTerms = 
            list('rna_seq',
                 '::all',
                 'biospecimen',
                 'subject',
                 'group'),
        format = 'df')
    print(query_df)
}

}
\seealso{
\url{https://mountetna.github.io/magma.html#query} for documentation of the underlying magma/query function.

\code{\link{retrieveProjects}} for exploring options for the \code{projectName} input.

\code{\link{retrieveModels}}, \code{\link{retrieveIds}}, and \code{\link{retrieveAttributes}} and \code{\link{retrieveTemplate}} for exploring the project structure and determining \code{queryTerm} options.
}
