\name{mselect}
\alias{mselect}
\alias{mselect<-}
\title{MSelect}
\description{Select values from a MAgPIE-object}
\usage{mselect(x, ..., collapseNames=FALSE)
mselect(x, ...) <- value}
\arguments{
  \item{x}{MAgPIE object}
  \item{...}{entry selections of the form \code{set_name=c(set_elem1,set_elem2)}. Alternatively a single list element containing these selections can be provided.}
  \item{collapseNames}{Boolean which decides whether names should be collapsed or not.}
  \item{value}{values on which the selected magpie entries should be set.}
}
\details{This functions only work for MAgPIE objects with named dimensions as the dimension name (set_name) has to be used to indicate in which dimension the entries should be searched for!}
\value{The reduced MAgPIE object containing only the selected entries or the full MAgPIE object in which a selection of entries was manipulated.}
\author{Jan Philipp Dietrich}
\seealso{\code{\link{collapseNames}}, \code{"\linkS4class{magpie}"}}
\examples{
 data(population_magpie)
 population_magpie
 mselect(population_magpie,i=c("AFR","EUR"),scenario="A2",t="y2035")
}
