% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-data_summarise.R
\name{summary_variables_categorical}
\alias{summary_variables_categorical}
\title{Provide descriptive statistics for variables of categorical in a dataset}
\usage{
summary_variables_categorical(
  dataset = NULL,
  data_dict = NULL,
  .dataset_preprocess = NULL
)
}
\arguments{
\item{dataset}{A tibble identifying the input dataset observations
associated to its data dictionary.}

\item{data_dict}{A list of tibble(s) representing meta data of an
associated dataset. Automatically generated if not provided.}

\item{.dataset_preprocess}{A tibble which provides summary of the variables
(for internal processes and programming).}
}
\value{
A tibble providing statistical description of 'categorical' variables
present in a dataset.
}
\description{
Summarises (in a tibble) the columns of type 'categorical' in a dataset and
its data dictionary (if any). The summary provides information about
quality, type, composition, and descriptive statistics of variables.
Statistics are generated by valueType.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.

A dataset must be a data frame-like object and can be associated with a
data dictionary. If no data dictionary is provided, a minimum workable
data dictionary will be generated as needed by relevant functions.
An identifier \code{id} column for sorting can be specified by the user. If
specified, the \code{id} values must be non-missing and will be used in functions
that require it. If no identifier column is specified, indexing is handled
automatically by the function.

The valueType is a property of a variable and is required in certain
functions to determine the handling of the variables. The valueType refers
to the OBiBa-internal type of a variable. It is specified in a data
dictionary in a column \code{valueType} and can be associated with variables as
attributes. Acceptable valueTypes include 'text', 'integer', 'decimal',
'boolean', datetime', 'date'). The full list of OBiBa valueType
possibilities and their correspondence with R data types are available using
\link{valueType_list}.
}
\examples{
{

# use DEMO_files provided by the package
library(dplyr)

###### Example : any data frame (or tibble) can be a dataset by definition.
.dataset_preprocess <- dataset_preprocess(storms['status'])
summary_variables_categorical(.dataset_preprocess = .dataset_preprocess)

}

}
