% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/boxroc.R
\name{boxroc}
\alias{boxroc}
\title{Boxplot and ROC Curves}
\usage{
boxroc(Y, EZ, xiT, BOXPLOT = FALSE, ROC = FALSE, Lroc = 100,
  labelsPlot = NULL, powdist = 2, cexRocLeg = 0.8, colRoc = seq(2, Ndata
  + 1), ltyRoc = seq(2, Ndata + 1), lwdRoc = 2, ...)
}
\arguments{
\item{Y}{(\code{N} x \code{N}) binary adjacency matrix, or list containing the adjacency matrices.}

\item{EZ}{(\code{N} x \code{D}) matrix (or list of matrices) containing the posterior means of the latent positions}

\item{xiT}{vector of posterior means of the parameter \eqn{\alpha}}

\item{BOXPLOT}{logical; if \code{TRUE} draws the boxplot. Default \code{BOXPLOT = FALSE}}

\item{ROC}{logical; if \code{TRUE} draws the ROC curve. Default \code{ROC = FALSE}}

\item{Lroc}{number of intervals in the ROC curve. Default \code{Lroc = 100}}

\item{labelsPlot}{main title for the boxplot. Default \code{labelsPlot = NULL}}

\item{powdist}{vector of power of the distance default \code{powdist = 2}, squared Euclidean distance, the alternative is 1, for the Euclidean distance}

\item{cexRocLeg}{\code{cex} for the ROC curve. Default \code{cexRocLeg = .8}}

\item{colRoc}{\code{col} for the ROC curve. Default \code{colRoc = seq(2, Ndata + 1)}}

\item{ltyRoc}{\code{lty} for the ROC curve. Default \code{ltyRoc = seq(2, Ndata + 1)}}

\item{lwdRoc}{\code{lwd} for the ROC curve. Default \code{lwdRoc = 2}}

\item{...}{Arguments to be passed to methods, such as graphical parameters (see \code{\link{par}}).}
}
\value{
The area under the ROC curve (AUC) and the selected plots. The closer the AUC takes values to 1 the better the fit.
}
\description{
Function to display boxplots and ROC curves to show model fit in terms of in-sample link prediction.
}
\examples{
N <- 20
Y <- network(N, directed = FALSE)[,]

modLSM <- lsm(Y, D = 2)
bp <- boxroc(Y,
	EZ = modLSM$lsmEZ,
	xiT = modLSM$xiT,
	Lroc = 150,
	ROC = TRUE,
	BOXPLOT = TRUE)

print(bp)
}
\references{
Gollini, I., and Murphy, T. B. (2014), "Joint Modelling of Multiple Network Views", Journal of Computational and Graphical Statistics \url{http://arxiv.org/abs/1301.3759}.
}
\seealso{
\code{\link{lsm}}, \code{\link{lsjm}}
}

