% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotY.R
\name{plotY}
\alias{plotY}
\title{Plot the adjacency matrix of the network}
\usage{
plotY(Y, Ndata = NULL, EZ = NULL, VZ = NULL, dimZ = c(1, 2),
  labels = NULL, colPl = 1, colEll = rgb(0.6, 0.6, 0.6, alpha = 0.1),
  LEVEL = 0.95, pchplot = 20, pchEll = 19, pchPl = 19,
  cexPl = 1.1, arrowhead = FALSE, curve = NULL, lwdLine = 0.3,
  xlim = NULL, ylim = NULL, verbose = FALSE, ...)
}
\arguments{
\item{Y}{list, or matrix containing a (\code{N} x \code{N}) binary adjacency matrix for each network view.}

\item{Ndata}{number of network views}

\item{EZ}{posterior mean latent positions}

\item{VZ}{posterior variance latent positions, if specified  draw ellipse}

\item{dimZ}{dimensions of Z to be plotted, default \code{dimZ = c(1, 2)}}

\item{labels}{text to be added in the plot representing the labels of each node. Default \code{labels = NULL}, no labels are shown}

\item{colPl}{\code{col} for the points representing the nodes. Default \code{colPl = NULL}}

\item{colEll}{\code{col} for the ellipses. Default \code{rgb(.6, .6 ,.6 , alpha=.1)}}

\item{LEVEL}{levels of confidence bounds shown when plotting the ellipses. Default \code{LEVEL = .95}}

\item{pchplot}{Default \code{pchplot = 20}}

\item{pchEll}{\code{pch} for the ellipses. Default \code{pchEll = 19}}

\item{pchPl}{\code{pch} for the points representing the nodes. Default \code{pchPl = 19}}

\item{cexPl}{\code{cex} for the points representing the nodes. Default \code{cexPl = 1.1}}

\item{arrowhead}{logical, if the arrowed are to be plotted. Default \code{arrowhead = FALSE}}

\item{curve}{curvature of edges. Default \code{curve = 0}}

\item{lwdLine}{lwd of edges. Default \code{lwdLine = .3}}

\item{xlim}{range for x}

\item{ylim}{range for y}

\item{verbose}{if \code{verbose = TRUE} save the nodal positions}

\item{...}{Arguments to be passed to methods, such as graphical parameters (see \code{\link{par}}).}
}
\description{
Function to plot the adjacency matrix of the network.
}
\examples{
N <- 20
Y <- network(N, directed = FALSE)[,]
plotY(Y)
# Store the positions of nodes used to plot Y, in order to redraw the plot using 
# the same positions
z <- plotY(Y, verbose = TRUE)
plotY(Y, EZ = z)
}
