% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{luz_callback_lr_scheduler}
\alias{luz_callback_lr_scheduler}
\title{Learning rate scheduler callback}
\usage{
luz_callback_lr_scheduler(
  lr_scheduler,
  ...,
  call_on = "on_epoch_end",
  opt_name = NULL
)
}
\arguments{
\item{lr_scheduler}{A \code{\link[torch:lr_scheduler]{torch::lr_scheduler()}} that will be initialized with
the optimizer and the \code{...} parameters.}

\item{...}{Additional arguments passed to \code{lr_scheduler} together with
the optimizers.}

\item{call_on}{The callback breakpoint that \code{scheduler$step()} is called.
Default is \code{'on_epoch_end'}. See \code{\link[=luz_callback]{luz_callback()}} for more information.}

\item{opt_name}{name of the optimizer that will be affected by this callback.
Should match the name given in \code{set_optimizers}. If your module has a single
optimizer, \code{opt_name} is not used.}
}
\value{
A \code{\link[=luz_callback]{luz_callback()}} generator.
}
\description{
Initializes and runs \code{\link[torch:lr_scheduler]{torch::lr_scheduler()}}s.
}
\examples{
if (torch::torch_is_installed()) {
cb <- luz_callback_lr_scheduler(torch::lr_step, step_size = 30)
}
}
\seealso{
Other luz_callbacks: 
\code{\link{luz_callback_csv_logger}()},
\code{\link{luz_callback_early_stopping}()},
\code{\link{luz_callback_interrupt}()},
\code{\link{luz_callback_metrics}()},
\code{\link{luz_callback_model_checkpoint}()},
\code{\link{luz_callback_profile}()},
\code{\link{luz_callback_progress}()},
\code{\link{luz_callback_train_valid}()},
\code{\link{luz_callback}()}
}
\concept{luz_callbacks}
