% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals.r
\name{int_standardize}
\alias{int_standardize}
\title{Ensures all intervals in an interval object are positive}
\usage{
int_standardize(int)
}
\arguments{
\item{int}{an Interval object}
}
\description{
If an interval is not positive, int_standardize flips it so that it
retains its endpoints but becomes positive.
}
\examples{
int <- interval(ymd("2002-01-01"), ymd("2001-01-01"))
# 2002-01-01 UTC--2001-01-01 UTC
int_standardize(int)
# 2001-01-01 UTC--2002-01-01 UTC
}

