% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSim.R
\name{dataSim}
\alias{dataSim}
\title{Simulate data}
\usage{
dataSim(n = 200, p = 20, bLength = 4, a = c(0.9, 0.5, 0),
  SD = c(10, 5, 2), eps = 0, eta = 25, setting = "3", seed = 123,
  vc = NULL)
}
\arguments{
\item{n}{number of observations}

\item{p}{number of variables}

\item{bLength}{the number of correlated variables in the first k blocks}

\item{a}{numveric vector of length k+1 that contains the correlations between the variables in each block (the last block contains uncorrelated variables); by default is (0.9, 0.5, 0)}

\item{SD}{numveric vector of length k+1 that contains the standard deviation of the variables in each block (the last block contains uncorrelated variables); by default is (10, 5, 2)}

\item{eps}{proportion of outliers, default is 0}

\item{eta}{parameter that contols the outlyingness, default is 25}

\item{setting}{type of outliers: \code{setting}="1" generates the outliers which are outlying in the first two variables in the second block; \code{setting}="2" generates
score outliers; \code{setting}="3" generates the orthogonal outliers which are easy to detect (the setting used in Hubert, et al (2016)); default is "3"}

\item{seed}{random seed used to simulate the data}

\item{vc}{controls the direction of the score outliers within the PC subspace, default is NULL}
}
\value{
a list with components \cr
\item{data}{generated data matrix}
\item{ind}{row indices of outliers}
\item{R}{Correlation matrix of the data}
\item{Sigma}{Covariance matrix of the data}
}
\description{
the function that generates the simulation data set
}
