% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsampling.R
\name{subsampling}
\alias{subsampling}
\title{Subsampling}
\usage{
subsampling(x, y, intercept = TRUE, weights = NULL, grouping = NULL,
  groupWeights = NULL, parameterWeights = NULL, alpha = 1, lambda,
  d = 100, train, test, collapse = FALSE, max.threads = NULL,
  use_parallel = FALSE, algorithm.config = lsgl.standard.config)
}
\arguments{
\item{x}{design matrix, matrix of size \eqn{N \times p}.}

\item{y}{response matrix, matrix of size \eqn{N \times K}.}

\item{intercept}{should the model include intercept parameters.}

\item{weights}{sample weights, vector of size \eqn{N \times K}.}

\item{grouping}{grouping of features, a factor or vector of length \eqn{p}. Each element of the factor/vector specifying the group of the feature.}

\item{groupWeights}{the group weights, a vector of length \eqn{m} (the number of groups).}

\item{parameterWeights}{a matrix of size \eqn{K \times p}.}

\item{alpha}{the \eqn{\alpha} value 0 for group lasso, 1 for lasso, between 0 and 1 gives a sparse group lasso penalty.}

\item{lambda}{lambda.min relative to lambda.max or the lambda sequence for the regularization path (that is a vector or a list of vectors with the lambda sequence for the subsamples).}

\item{d}{length of lambda sequence (ignored if \code{length(lambda) > 1})}

\item{train}{a list of training samples, each item of the list corresponding to a subsample.
Each item in the list must be a vector with the indices of the training samples for the corresponding subsample.
The length of the list must equal the length of the \code{test} list.}

\item{test}{a list of test samples, each item of the list corresponding to a subsample.
Each item in the list must be vector with the indices of the test samples for the corresponding subsample.
The length of the list must equal the length of the \code{training} list.}

\item{collapse}{if \code{TRUE} the results for each subsample will be collapse into one result (this is useful if the subsamples are not overlapping)}

\item{max.threads}{Deprecated (will be removed in 2018),
instead use \code{use_parallel = TRUE} and registre parallel backend (see package 'doParallel').
The maximal number of threads to be used.}

\item{use_parallel}{If \code{TRUE} the \code{foreach} loop will use \code{\%dopar\%}. The user must registre the parallel backend.}

\item{algorithm.config}{the algorithm configuration to be used.}
}
\value{
\item{Yhat}{if \code{collapse = FALSE} then a list of length \code{length(test)} containing the predicted responses for each of the test sets. If \code{collapse = TRUE} a list of length \code{length(lambda)}}
\item{Y.true}{a list of length \code{length(test)} containing the true responses of the test samples}
\item{features}{number of features used in the models}
\item{parameters}{number of parameters used in the models.}
}
\description{
Linear multiple output subsampling using multiple possessors
}
\examples{

set.seed(100) # This may be removed, it ensures consistency of the daily tests

## Simulate from Y=XB+E, the dimension of Y is N x K, X is N x p, B is p x K

N <- 100 #number of samples
p <- 50 #number of features
K <- 25  #number of groups

B <- matrix(sample(c(rep(1,p*K*0.1),rep(0, p*K-as.integer(p*K*0.1)))),nrow=p,ncol=K)
X1 <- matrix(rnorm(N*p,1,1),nrow=N,ncol=p)
Y1 <- X1\%*\%B+matrix(rnorm(N*K,0,1),N,K)

## Do cross subsampling

train <- replicate(2, sample(1:N, 50), simplify = FALSE)
test <- lapply(train, function(idx) (1:N)[-idx])

lambda <- lapply(train, function(idx)
lsgl::lambda(
	x = X1[idx,],
	y = Y1[idx,],
	alpha = 1,
	d = 15L,
	lambda.min = 5,
	intercept = FALSE)
)

fit.sub <- lsgl::subsampling(
 x = X1,
 y = Y1,
 alpha = 1,
 lambda = lambda,
 train = train,
 test = test,
 intercept = FALSE
)

Err(fit.sub)

## Do the same cross subsampling using 2 parallel units
cl <- makeCluster(2)
registerDoParallel(cl)

# Run subsampling
# Using a lambda sequence ranging from the maximal lambda to 0.1 * maximal lambda
fit.sub <- lsgl::subsampling(
 x = X1,
 y = Y1,
 alpha = 1,
 lambda = 0.1,
 train = train,
 test = test,
 intercept = FALSE
)

stopCluster(cl)

Err(fit.sub)
}
\author{
Martin Vincent
}

