% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rmdiff}
\alias{rmdiff}
\title{Estimate of restricted mean survival time difference}
\usage{
rmdiff(
  data,
  rep = "rep",
  stratum = "stratum",
  treat = "treat",
  time = "time",
  event = "event",
  milestone = NA_real_,
  rmstDiffH0 = 0,
  confint = 0.95,
  biascorrection = 0L
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{rep}: The replication for by-group processing.
\item \code{stratum}: The stratum.
\item \code{treat}: The treatment.
\item \code{time}: The possibly right-censored survival time.
\item \code{event}: The event indicator.
}}

\item{rep}{The name of the replication variable in the input data.}

\item{stratum}{The name of the stratum variable in the input data.}

\item{treat}{The name of the treatment variable in the input data.}

\item{time}{The name of the time variable in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{milestone}{The milestone time at which to calculate the
restricted mean survival time.}

\item{rmstDiffH0}{The difference in restricted mean survival times
under the null hypothesis. Defaults to 0 for superiority test.}

\item{confint}{The level of the two-sided confidence interval for
the difference in restricted mean survival times. Defaults to 0.95.}

\item{biascorrection}{Whether to apply bias correction for the
variance estimate of individual restricted mean survival times.
Defaults to no bias correction.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{rep}: The replication number.
\item \code{milestone}: The milestone time relative to randomization.
\item \code{rmstDiffH0}: The difference in restricted mean survival times
under the null hypothesis.
\item \code{rmst1}: The estimated restricted mean survival time for
the treatment group.
\item \code{rmst2}: The estimated restricted mean survival time for
the control group.
\item \code{rmstDiff}: The estimated difference in restricted mean
survival times.
\item \code{vrmst1}: The variance for rmst1.
\item \code{vrmst2}: The variance for rmst2.
\item \code{vrmstDiff}: The variance for rmstDiff.
\item \code{rmstDiffZ}: The Z-statistic value.
\item \code{rmstDiffPValue}: The one-sided p-value.
\item \code{lower}: The lower bound of confidence interval.
\item \code{upper}: The upper bound of confidence interval.
\item \code{confint}: The level of confidence interval.
\item \code{biascorrection}: Whether to apply bias correction for the
variance estimate of individual restricted mean survival times.
}
}
\description{
Obtains the estimate of restricted mean survival time
difference between two treatment groups.
}
\examples{

df <- rmdiff(data = rawdata, rep = "iterationNumber",
             stratum = "stratum", treat = "treatmentGroup",
             time = "timeUnderObservation", event = "event",
             milestone = 12)
head(df)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
