% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_datatype.R
\name{get_datatype}
\alias{get_datatype}
\title{Data type of an LPJmL input/output file}
\usage{
get_datatype(header, fail = TRUE)
}
\arguments{
\item{header}{Header list object as returned by \code{\link[=read_header]{read_header()}} or
\code{\link[=create_header]{create_header()}}. Alternatively, can be a single integer just giving the
data type code or a single character string giving one of the LPJmL type
names \code{c("byte", "short", "int", "float", "double")}.}

\item{fail}{Determines whether the function should fail if the datatype is
invalid (default: \code{TRUE}).}
}
\value{
On success, the function returns a list object with three components:
\itemize{
\item type: R data type; can be used with \code{what} parameter of \code{\link[=readBin]{readBin()}}.
\item size: size of data type; can be used with \code{size} parameter of
\code{\link[=readBin]{readBin()}}.
\item signed: whether or not the data type is signed; can be used with \code{signed}
parameter of \code{\link[=readBin]{readBin()}}.
}

If \code{fail = FALSE}, the function returns \code{NULL} if an invalid datatype is
provided.
}
\description{
Provides information on the data type used in an LPJmL
input/output file based on the 'datatype' attribute included in the file
header.
}
\examples{
\dontrun{
# Read file header
header <- read_header("filename.clm")
# Open file for reading
fp <- file("filename.clm", "rb")
# Skip over file header
seek(fp, get_headersize(header))
# Read in file data
file_data <- readBin(
  fp,
  what = get_datatype(header)$type,
  size = get_datatype(header)$size,
  signed = get_datatype(header)$signed,
  n = header$header["ncell"] * header$header["nbands"] *
      header$header["nyear"] * header$header["nstep"],
  endian = header[["endian"]]
)
# Close file
close(fp)
}

}
\seealso{
\itemize{
\item \code{\link[=read_header]{read_header()}} for reading headers from LPJmL input/output files.
\item \code{\link[=create_header]{create_header()}} for creating headers from scratch.
\item \code{\link[=get_headersize]{get_headersize()}} for determining the size of file headers.
}
}
