% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpbwdensity.R
\name{lpbwdensity}
\alias{lpbwdensity}
\title{Data-driven Bandwidth Selection for Local Polynomial Density Estimation}
\usage{
lpbwdensity(data, grid = c(), bwselect = c("MSE", "IMSE", "ROT", "IROT"),
  p = c(), v = c(), kernel = c("triangular", "uniform", "epanechnikov"),
  Cweights = c(), Pweights = c(), regularize = TRUE)
}
\arguments{
\item{data}{Numeric vector or one dimensional matrix / data frame, the raw data.}

\item{grid}{Numeric vector or one dimensional matrix / data frame, the grid on which
density is estimated. When set to default, grid points will be chosen as 0.05-0.95
percentiles of the data, with 0.05 step size.}

\item{bwselect}{String, the method for data-driven bandwidth selection. This option will be
ignored if \code{bw} is provided. Can be (1) \code{"MSE"} (default, mean squared error-optimal
bandwidth selected for each grid point); or (2) \code{"IMSE"} (integrated MSE-optimal bandwidth,
common for all grid points); (3) \code{"ROT"} (rule-of-thumb bandwidth with Gaussian
reference model); and (4) \code{"IROT"} (integrated rule-of-thumb bandwidth with Gaussian
reference model).}

\item{p}{Integer, the order of the local-polynomial used to construct point
estimates. Should be larger than 0. (Default is 2.)}

\item{v}{Integer, the derivative to be estimated. Default is \code{1}, which is the density function.
Should be nonnegative.}

\item{kernel}{String, the kernel function, should be one of \code{"triangular"}, \code{"uniform"} or
\code{"epanechnikov"}.}

\item{Cweights}{Numeric vector or one dimensional matrix / data frame, the weights used
for counterfactual distribution construction. Should have the same length as sample size.
This option will be ignored if \code{bwselect} is \code{"ROT"} or \code{"IROT"}.}

\item{Pweights}{Numeric vector or one dimensional matrix / data frame, the weights used
in sampling. Should have the same length as sample size, and nonnegative.
This option will be ignored if \code{bwselect} is \code{"ROT"} or \code{"IROT"}.}

\item{regularize}{\code{TRUE} (default) or \code{FALSE}, whether the bandwidth should be
regularized. When set to \code{TRUE}, the bandwidth is chosen such that at least 20 + \code{p} + 1
are available locally.}
}
\value{
\item{BW}{A matrix containing (1) \code{grid} (grid points), (2) \code{bw} (bandwidths), and
  (3) \code{nh} (effective/local sample sizes).}
\item{opt}{A list containing options passed to the function.}
}
\description{
\code{lpbwdensity} implements the bandwidth selector for local polynomial based density (and derivatives) estimation,
  proposed in Cattaneo, Jansson and Ma (2017).
}
\details{
Companion command: \code{\link{lpdensity}} for local polynomial density estimation.
}
\examples{
set.seed(42); X <- rnorm(1000)
lpbwdensity(X)

}
\references{
M. D. Cattaneo, M. Jansson and X. Ma. (2017). \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Jansson-Ma_2017_LocPolDensity.pdf}{Simple Local Regression Distribution Estimators}. Working Paper, University of Michigan.
}
\seealso{
\code{\link{lpdensity}}.
}
\author{
Matias D. Cattaneo, University of Michigan. \email{cattaneo@umich.edu}.

Michael Jansson, University of California, Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of Michigan. \email{xinweima@umich.edu}.
}
