% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpcde_methods.R
\name{summary.lpcde}
\alias{summary.lpcde}
\title{Summary method for local polynomial density conditional estimation}
\usage{
\method{summary}{lpcde}(object, ...)
}
\arguments{
\item{object}{Class "lpcde" object, obtained from calling \code{\link{lpcde}}.}

\item{...}{Additional options, including (i)\code{y_grid} specifies
a subset of grid points in y- directions
to display results; (ii) \code{gridIndex} specifies the indices of grid points
to display results; (iii) \code{alpha} specifies the significance level; (iv)
\code{CIuniform} specifies whether displaying pointwise confidence intervals (\code{FALSE}, default) or
the uniform confidence band (\code{TRUE}); (v) \code{CIsimul} specifies the number of simulations used
to construct critical values (default is \code{2000}).}
}
\value{
\item{Display output}{A list of specified options and a matrix of grid points and estimates.}
}
\description{
The summary method for local polynomial conditional density objects.
}
\examples{
n=100
x_data = as.matrix(rnorm(n, mean=0, sd=1))
y_data = as.matrix(rnorm(n, mean=0, sd=1))
y_grid = stats::quantile(y_data, seq(from=0.1, to=0.9, by=0.1))
# density estimation
model1 = lpcde::lpcde(x_data=x_data, y_data=y_data, y_grid=y_grid, x=0, bw=0.5)
summary(model1)

}
\seealso{
\code{\link{lpcde}} for local polynomial conditional density estimation.
Supported methods: \code{\link{coef.lpcde}}, \code{\link{confint.lpcde}},
\code{\link{plot.lpcde}}, \code{\link{print.lpcde}},
\code{\link{summary.lpcde}}, \code{\link{vcov.lpcde}}
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Rajita Chandak (maintainer), Princeton University. \email{rchandak@princeton.edu}

Michael Jansson, University of California Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma, University of California San Diego. \email{x1ma@ucsd.edu}.
}
