% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lori.R
\name{lori}
\alias{lori}
\title{Main function to be used to fit the LORI model}
\usage{
lori(Y, R = NULL, C = NULL, lambda = NULL,
  projection = default_projection, gamma_init = NULL, X_init = NULL,
  Theta_init = NULL, tau = 0.1, epsilon = 1e-06, tol = 1e-12,
  max_it = 5 * 1e+05, upper = -log(1e-06), lower = log(1e-06))
}
\arguments{
\item{Y}{a matrix of counts (m1 x m2).}

\item{R}{a matrix of row covariates (m1 x K1)}

\item{C}{a matrix of column covariates (m2 x K2)}

\item{lambda}{a positive number, the regularization parameter}

\item{projection}{a projection function, by default centers by rows and columns}

\item{gamma_init}{an initial value for the dual matrix (dual variable, same size as Y).}

\item{X_init}{an initial value for the parameter matrix (dual variable, same size as Y).}

\item{Theta_init}{an initial value for the matrix of interactions (same size as Y).}

\item{tau}{a positive number (augmented Lagrangian parameter)}

\item{epsilon}{a positive number, the convergence criterion}

\item{tol}{a positive number, the convergence criterion for optimization step inside iterations}

\item{max_it}{a positive number, the maximum number of iterations}

\item{upper}{a number, the upper bound on the entries of matrix X}

\item{lower}{a number, the lower bound on the entries of matrix X}
}
\value{
The value of the augmented Lagrangian (with fixed \code{Theta} and \code{gamma}) taken at \code{X}.
}
\description{
Main function to be used to fit the LORI model
}
\examples{
X = matrix(rnorm(rep(0, 15)), 5)
Y <- matrix(rpois(length(c(X)), exp(c(X))), 5)
res_lori <- lori(Y)
}
