% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer_heatImage.R
\name{l_layer_heatImage}
\alias{l_layer_heatImage}
\title{Display a Heat Image}
\usage{
l_layer_heatImage(
  widget,
  x = seq(0, 1, length.out = nrow(z)),
  y = seq(0, 1, length.out = ncol(z)),
  z,
  zlim = range(z[is.finite(z)]),
  xlim = range(x),
  ylim = range(y),
  col = grDevices::heat.colors(12),
  breaks,
  oldstyle = FALSE,
  useRaster,
  index = "end",
  parent = "root",
  ...
)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{x}{locations of grid lines at which the values in z are measured. These
must be finite, non-missing and in (strictly) ascending order. By default,
equally spaced values from 0 to 1 are used. If x is a list, its components
x$x and x$y are used for x and y, respectively. If the list has component z
this is used for z.}

\item{y}{see description for the \code{x} argument above}

\item{z}{a numeric or logical matrix containing the values to be plotted
    (\code{NA}s are allowed).  Note that \code{x} can be used instead
    of \code{z} for convenience.}

\item{zlim}{the minimum and maximum \code{z} values for which colors
    should be plotted, defaulting to the range of the finite values of
    \code{z}. Each of the given colors will be used to color an
    equispaced interval of this range. The \emph{midpoints} of the
    intervals cover the range, so that values just outside the range
    will be plotted.}

\item{xlim}{range for the plotted x values, defaulting to the range of x}

\item{ylim}{range for the plotted y values, defaulting to the range of y}

\item{col}{a list of colors such as that generated by
    \code{\link{hcl.colors}}, \code{\link{gray.colors}} or similar
    functions.}

\item{breaks}{a set of finite numeric breakpoints for the colours:
    must have one more breakpoint than colour and be in increasing
    order.  Unsorted vectors will be sorted, with a warning.}

\item{oldstyle}{logical. If true the midpoints of the colour intervals
    are equally spaced, and \code{zlim[1]} and \code{zlim[2]} were taken
    to be midpoints.  The default is to have colour intervals of equal
    lengths between the limits.}

\item{useRaster}{logical; if \code{TRUE} a bitmap raster is used to
    plot the image instead of polygons. The grid must be regular in that
    case, otherwise an error is raised.   For the behaviour when this is
    not specified, see \sQuote{Details}.}

\item{index}{position among its siblings. valid values are 0, 1, 2, ...,
'end'}

\item{parent}{parent widget path}

\item{...}{argumnets forwarded to \code{\link{l_layer_line}}}
}
\value{
layer id of group or rectangles layer
}
\description{
This function is very similar to the
  \code{\link[graphics]{image}} function. It works with every loon plot which
  is based on the cartesian coordinate system.
}
\details{
For more information run: \code{l_help("learn_R_layer.html#countourlines-heatimage-rasterimage")}
}
\examples{

if(interactive()){

if (requireNamespace("MASS", quietly = TRUE)) {
  kest <- with(iris, MASS::kde2d(Sepal.Width,Sepal.Length))
  image(kest)
  contour(kest, add=TRUE)

  p <- l_plot()
  lcl <- l_layer_contourLines(p, kest, label='contour lines')
  limg <- l_layer_heatImage(p, kest, label='heatmap')
  l_scaleto_world(p)
}

# from examples(image)
x <- y <- seq(-4*pi, 4*pi, len = 27)
r <- sqrt(outer(x^2, y^2, "+"))
p1 <- l_plot()
l_layer_heatImage(p1, z = z <- cos(r^2)*exp(-r/6), col  = gray((0:32)/32))
l_scaleto_world(p1)

image(z = z <- cos(r^2)*exp(-r/6), col  = gray((0:32)/32))

}
}
