% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{elife}
\alias{elife}
\alias{qelife}
\alias{pelife}
\alias{relife}
\alias{delife}
\alias{helife}
\title{Excess lifetime distributions}
\usage{
qelife(
  p,
  rate,
  scale,
  shape,
  family = c("exp", "gp", "weibull", "gomp", "gompmake", "extgp", "extweibull", "perks",
    "perksmake", "beard", "beardmake"),
  lower.tail = TRUE
)

pelife(
  q,
  rate,
  scale,
  shape,
  family = c("exp", "gp", "weibull", "gomp", "gompmake", "extgp", "extweibull", "perks",
    "perksmake", "beard", "beardmake"),
  lower.tail = TRUE,
  log.p = FALSE
)

relife(
  n,
  scale = 1,
  rate,
  shape,
  family = c("exp", "gp", "weibull", "gomp", "gompmake", "extgp", "extweibull", "perks",
    "perksmake", "beard", "beardmake")
)

delife(
  x,
  scale = 1,
  rate,
  shape,
  family = c("exp", "gp", "weibull", "gomp", "gompmake", "extgp", "extweibull", "perks",
    "perksmake", "beard", "beardmake"),
  log = FALSE
)

helife(
  x,
  scale = 1,
  rate,
  shape,
  family = c("exp", "gp", "weibull", "gomp", "gompmake", "extgp", "extweibull", "perks",
    "perksmake", "beard", "beardmake"),
  log = FALSE
)
}
\arguments{
\item{p}{vector of probabilities}

\item{rate}{rate parameter(s); for models with Makeham component, the last entry should be part of the rate vector}

\item{scale}{scale parameter}

\item{shape}{vector of shape parameter(s).}

\item{family}{string indicating the parametric model, one of \code{exp}, \code{gp}, \code{gomp}, \code{gompmake}, \code{weibull}, \code{extgp}, \code{extweibull}, \code{perks}, \code{perksmake}, \code{beard} and \code{beardmake}}

\item{lower.tail}{logical; if \code{TRUE} (default), the lower tail probability \eqn{\Pr(X \leq x)} is returned.}

\item{q}{vector of quantiles.}

\item{n}{sample size}

\item{log, log.p}{logical; if \code{TRUE}, values are returned on the logarithmic scale (default to \code{FALSE}).}
}
\value{
depending on the function type, a vector of probabilities (\code{pelife}), quantiles (\code{qelife}), density (\code{delife}), or hazard (\code{helife}). The function \code{relife} returns a random sample of size \code{n} from the distribution.
}
\description{
Quantile, distribution, density and hazard functions of excess lifetime distribution
for threshold exceedances.
}
\keyword{internal}
