% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axecute.R
\name{axecute}
\alias{axecute}
\title{Creation of a log and axecution of a file}
\usage{
axecute(
  file,
  log_name = NA,
  log_path = NA,
  remove_log_object = TRUE,
  quit_on_error = TRUE,
  to_report = c("messages", "output", "result")
)
}
\arguments{
\item{file}{String. Path to file to execute}

\item{log_name}{String. Name of log file}

\item{log_path}{String. Path to log file}

\item{remove_log_object}{Boolean. Should the log object be removed after
writing the log file? Defaults to TRUE}

\item{quit_on_error}{Boolean. Should the session quit with status 1 on error?
Defaults to TRUE}

\item{to_report}{String vector. Objects to optionally report, may include as
many as necessary:
\itemize{
\item messages: any messages generated by program execution
\item output: any output generated by program execution
\item result: any result generated by program execution
}}
}
\value{
0 if there are no errors or 1 if there are any errors
}
\description{
\code{axecute()} creates a log, executes a file, and returns 0 if there are no
errors or 1 if there are any errors
}
\examples{
dir <- tempdir()
text <- 'print("Hello, logrxperson!")'
fileConn <- file(file.path(dir, "hello.R"))
writeLines(text, fileConn)
close(fileConn)

axecute(file.path(dir, "hello.R"))
}
