% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocorr.R
\name{computeEffectiveAutoCorr}
\alias{computeEffectiveAutoCorr}
\title{Estimate vector of effective components of the autocorrelation}
\usage{
computeEffectiveAutoCorr(res, type = "correlation")
}
\arguments{
\item{res}{numeric of autocorrelated numbers, usually observation - 
model residuals}

\item{type}{type of residuals (see \code{\link{acf}})}
}
\value{
numeric vector: strongest components of the autocorrelation function
}
\description{
Estimate vector of effective components of the autocorrelation
}
\details{
Returns all components before first negative autocorrelation
}
\examples{
# generate autocorrelated time series
res <- stats::filter(rnorm(1000), filter = rep(1,5), circular = TRUE)
res[100:120] <- NA
(effAcf <- computeEffectiveAutoCorr(res))
}
\references{
\code{Zieba 2011 Standard Deviation of the Mean of Autocorrelated
 Observations Estimated with the Use of the Autocorrelation Function Estimated
 From the Data}
}
