% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{run_standard_analysis_model}
\alias{run_standard_analysis_model}
\title{Standard Analysis Model}
\usage{
run_standard_analysis_model(data, sex_neutral = FALSE)
}
\arguments{
\item{data}{data.frame as produced by \code{\link{prepare_data}}}

\item{sex_neutral}{boolean indicating whether the linear regression is to be
run using the sex_neutral model or the standard one.}
}
\value{
an object of \code{\link{class}} "\code{\link[stats]{lm}}"
}
\description{
Estimates the Swiss Confederation standard analysis model (a linear
regression) for salary equality between women and men.
}
\details{
The standard analysis model's formula is the following:

\code{log(standardized_salary) ~ years_of_training + years_of_service +
years_of_earning + years_of_earning^2 + skill_level + professional_position +
sex}

The \code{sex_neutral} parameter can be used to run the sex neutral model,
i.e. a linear regression without the sex coefficient.
}
\keyword{internal}
