% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hf_token.R
\name{set_hf_token}
\alias{set_hf_token}
\title{Configure Hugging Face access token}
\usage{
set_hf_token(token, persist = FALSE, renviron_path = NULL)
}
\arguments{
\item{token}{Character scalar. Your Hugging Face access token, typically
starting with `hf_`.}

\item{persist}{Logical flag controlling whether to persist the token to a
startup file. Defaults to `FALSE`.}

\item{renviron_path}{Optional path to the `.Renviron` file to update when
`persist = TRUE`. Must be supplied explicitly when persisting.}
}
\value{
Invisibly returns the currently active token value.
}
\description{
Utility helper to manage the `HF_TOKEN` environment variable used for
authenticated downloads from Hugging Face. The token is set for the current
R session, and it can optionally be persisted to a `.Renviron` file for
future sessions. The token is not printed back to the console.
}
\examples{
\dontrun{
set_hf_token("hf_xxx")
tmp_env <- file.path(tempdir(), ".Renviron_localLLM")
set_hf_token("hf_xxx", persist = TRUE, renviron_path = tmp_env)
}

}
