% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{detokenize}
\alias{detokenize}
\title{Convert Token IDs Back to Text}
\usage{
detokenize(model, tokens)
}
\arguments{
\item{model}{A model object created with \code{\link{model_load}}. Must be the same model
that was used for tokenization to ensure proper decoding}

\item{tokens}{Integer vector of token IDs to convert back to text. These are typically
generated by \code{\link{tokenize}} or \code{\link{generate}}}
}
\value{
Character string containing the decoded text corresponding to the input tokens
}
\description{
Converts a sequence of integer token IDs back into human-readable text. This is the 
inverse operation of tokenization and is typically used to convert model output tokens
into text that can be displayed to users.
}
\examples{
\dontrun{
# Load model
model <- model_load("path/to/model.gguf")

# Tokenize then detokenize (round-trip)
original_text <- "Hello, how are you today?"
tokens <- tokenize(model, original_text)
recovered_text <- detokenize(model, tokens)
print(recovered_text)  # Should match original_text

# Generate and display text
ctx <- context_create(model)
generated_text <- generate(ctx, "The weather is", max_tokens = 10)

# Inspect individual tokens
single_token <- c(123)  # Some token ID
token_text <- detokenize(model, single_token)
print(paste("Token", single_token, "represents:", token_text))
}
}
\seealso{
\code{\link{tokenize}}, \code{\link{generate}}, \code{\link{model_load}}
}
