% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{average}
\alias{average}
\title{Estimation of Average Causal Effects from Marginal Treatment Effects}
\usage{
average(mte_fit, estimand = c("ate", "att", "atu"))
}
\arguments{
\item{mte_fit}{An object of class \code{mte} returned by \code{\link{mte}}.}

\item{estimand}{Type of estimand: \code{"ate"}, \code{"att"}, or \code{"atu"}.}
}
\value{
Estimate of ATE, ATT, or ATU.
}
\description{
\code{average} is a function that estimates conventional causal parameters including
average treatment effect (ATE), average treatment effect on the treated (ATT), and
average treatment effect on the untreated (ATU). Note that the estimation involves
substantial extrapolation when the propensity score has a limited support.
}
\examples{
mte_fit <- mte(selection = d ~ x + z, outcome = y ~ x,
  method = "localIV", data = toydata)

ate <- average(mte_fit, estimand = "ate")
att <- average(mte_fit, estimand = "att")
c(ate, att)

}
\references{
Heckman, James J., Sergio Urzua, and Edward Vytlacil. 2006.
  "Understanding Instrumental Variables in Models with Essential Heterogeneity."
  The Review of Economics and Statistics 88:389-432.
}
