% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localStrat.r
\name{jaccardMatrix}
\alias{jaccardMatrix}
\title{Cpp implementation of the Jaccard similarity matrix computation for a (sparse) input matrix.}
\usage{
jaccardMatrix(m, dense = FALSE)
}
\arguments{
\item{m}{A (sparse) matrix for which the Jaccard similarity matrix is sought. The input matrix is assumed to be oriented to contain the data for one individual per column.}

\item{dense}{Flag to switch between purpose-built dense or sparse implementations. Default is \code{dense=FALSE}.}
}
\value{
The Jaccard matrix of \code{m}.
}
\description{
Cpp implementation of the Jaccard similarity matrix computation for a (sparse) input matrix.
}
\examples{
library(locStra)
library(Matrix)
m <- matrix(sample(0:1,15,replace=TRUE),ncol=3)
sparseM <- Matrix(m,sparse=TRUE)
print(jaccardMatrix(sparseM))

}
\references{
Dmitry Prokopenko, Julian Hecker, Edwin Silverman, Marcello Pagano, Markus Noethen, Christian Dina, Christoph Lange and Heide Fier (2016). Utilizing the Jaccard index to reveal population stratification in sequencing data: a simulation study and an application to the 1000 Genomes Project. Bioinformatics, 32(9):1366-1372.
}
