% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.residual.lmvar.R
\name{df.residual.lmvar}
\alias{df.residual.lmvar}
\title{Residual degrees of freedom for an object of class 'lmvar'}
\usage{
\method{df.residual}{lmvar}(object, ...)
}
\arguments{
\item{object}{Object of class 'lmvar'}

\item{...}{For compatibility with \code{\link[stats]{df.residual}} generic}
}
\value{
Residual degees of freedom for \code{object}.
}
\description{
Residual degrees of freedom for an object of class 'lmvar'. The residual degrees of freedom are defined
as the number of observations minus the degrees of freedom of the model.
}
\examples{
# As example we use the dataset 'attenu' from the library 'datasets'. The dataset contains
# the response variable 'accel' and two explanatory variables 'mag'  and 'dist'.
library(datasets)

# To see how many observations the dataset contains, run
help("attenu")

# Create the model matrix for the expected values
X = cbind(attenu$mag, attenu$dist)
colnames(X) = c("mag", "dist")

# Create the model matrix for the standard deviations.
X_s = cbind(attenu$mag, 1 / attenu$dist)
colnames(X_s) = c("mag", "dist_inv")

# Carry out the fit
fit = lmvar(attenu$accel, X, X_s)

# The number of observations in the fit is
nobs(fit)

# The degrees of freedom are
dfree(fit)

# The residual degrees of freedom are
df.residual(fit)
}
\seealso{
\code{\link{dfree}} for the degrees of freedom of an object of class 'lmvar'

\code{\link{nobs.lmvar}} for the number of observations in an object of class 'lmvar'
}
