% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_lm_list_helprs.R
\name{summary.lm_list_lmhelprs}
\alias{summary.lm_list_lmhelprs}
\alias{print.summary_lm_list_lmhelprs}
\title{Summary of an \code{lm_list_lmhelprs}-Class
Object}
\usage{
\method{summary}{lm_list_lmhelprs}(object, ...)

\method{print}{summary_lm_list_lmhelprs}(x, digits = 3, ...)
}
\arguments{
\item{object}{The output of
\code{\link[=many_lm]{many_lm()}}.}

\item{...}{Other arguments. Not
used.}

\item{x}{An object of class
\code{summary_lm_list_lmhelprs}.}

\item{digits}{The number of
significant digits in printing
numerical results.}
}
\value{
\code{\link[=summary.lm_list_lmhelprs]{summary.lm_list_lmhelprs()}} returns a
\code{summary_lm_list_lmhelprs}-class object, which
is a list of the \code{\link[=summary]{summary()}} outputs
of the \code{\link[=lm]{lm()}} outputs stored.

\code{\link[=print.summary_lm_list_lmhelprs]{print.summary_lm_list_lmhelprs()}} returns \code{x}
invisibly. Called for its side
effect.

Adapted from the package \code{manymome}
such that \code{many_lm()} can be used
without \code{manymome}.
}
\description{
The summary of content
of the output of \code{\link[=many_lm]{many_lm()}}.
}
\section{Functions}{
\itemize{
\item \code{print(summary_lm_list_lmhelprs)}: Print
method for output of summary for
lm_list_lmhelprs.

}}
\examples{

data(data_test1)
mod <- "x3 ~ x2 + x1
        x4 ~ x3
        x5 ~ x4*x1"
out <- many_lm(mod, data_test1)
summary(out)

}
