% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information-matrices.R
\name{Fisher_info}
\alias{Fisher_info}
\title{Calculate expected, observed, or average Fisher information matrix}
\usage{
Fisher_info(mod, type = "expected", separate_variances = FALSE)
}
\arguments{
\item{mod}{Fitted model of class lmeStruct or glsStruct.}

\item{type}{Type of information matrix. One of \code{"expected"} (the
default), \code{"observed"}, or \code{"average"}.}

\item{separate_variances}{Logical indicating whether to return the Fisher
information matrix for separate level-1 variance components if using
\code{varIdent} function to allow for different variances per stratum.
Default is \code{FALSE}.}
}
\value{
Information matrix corresponding to variance component parameters of
  \code{mod}.

  If \code{separate_variances = TRUE} and if \code{weights = varIdent(form =
  ~ 1 | Stratum)} is specified in the model fitting, the Fisher information
  matrix for separate level-1 variance estimates will be returned. If
  \code{separate_variances = TRUE} but if the weighting structure is not
  specified with \code{varIdent}, or if \code{separate_variances = FALSE},
  then the Fisher information matrix for the default variance components will
  be returned.
}
\description{
Calculates the expected, observed, or average Fisher information
  matrix from a fitted linear mixed effects model (lmeStruct object) or
  generalized least squares model (glsStruct object).
}
\examples{

library(nlme)
data(Bryant2016)
Bryant2016_RML <- lme(fixed = outcome ~ treatment,
                      random = ~ 1 | school/case,
                      correlation = corAR1(0, ~ session | school/case),
                      data = Bryant2016)
Fisher_info(Bryant2016_RML, type = "expected")
Fisher_info(Bryant2016_RML, type = "average")

Bryant2016_RML2 <- lme(fixed = outcome ~ treatment,
                      random = ~ 1 | school/case,
                      correlation = corAR1(0, ~ session | school/case),
                      weights = varIdent(form = ~ 1 | treatment),
                      data = Bryant2016)
Fisher_info(Bryant2016_RML2, separate_variances = TRUE)

}
