% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mru.R
\name{mru}
\alias{mru}
\title{Multinomial Restricted MDU}
\usage{
mru(y, X, S = 2, start = "da", maxiter = 65536, dcrit = 1e-05)
}
\arguments{
\item{y}{An N vector of the responses (categorical).}

\item{X}{An N by P matrix with predictor variables}

\item{S}{Positive number indicating the dimensionality of teh solution}

\item{start}{Type of starting values (da: discriminant analysis, random or list with B and V)}

\item{maxiter}{maximum number of iterations}

\item{dcrit}{convergence criterion}
}
\value{
Y Matrix Y from input

Xoriginal Matrix X from input

X Scaled X matrix

G class indicator matrix

ynames class names of response variable

xnames variable names of the predictors

mx means of the predictor variables

sdx standard deviations of the predictor variables

U coordinate matrix of row objects

B matrix with regression coefficients

Class coordinate matrix

iters number of iterations

deviance value of the deviance at convergence
}
\description{
The function mru performs multinomial restricted unfolding for a nominal response
variable and a set of predictor variables.
}
\examples{
\dontrun{
data(dataExample_mru)
y = as.matrix(dataExample_mru[1:20 , 1])
X = as.matrix(dataExample_mru[1:20 , 2:6])
output = mru(y = y, X = X, S = 2)
}

}
